using System;
using Microsoft.SPOT;
using F75XDeviceApp.Common;
using Core.Utils;
using Core.Hardware;
using System.Threading;
using System.IO;
using Core;
using Core.Text;
using Microsoft.SPOT.IO;
using Core.UI;
using Core.Screens;
using Common;

namespace F75XDeviceApp
{
    public class ChemometricsApp : F75XApp
    {
        /**
        * In the future AppBuilder will generate this code for Customizations.cs
        */
        public ChemometricsApp()
        {

            BootText = "";
            Name = "ChemometricsApp v1.0";
            TextOutputFile = "ChemometricsAppLog.txt";
            ID = new Guid(new byte[] { 0xec, 0xab, 0x30, 0xb1, 0xab, 0x61, 0x01, 0x18, 0xb1, 0x0c, 0x26, 0x22, 0x73, 0x04, 0x0c, 0x10 });

            LotUtils.Root = @"\SD\Apps\ChemometricsApp\Data\";
            Environment.SettingsFolder = @"\SD\Apps\ChemometricsApp\Options\";
            Environment.ArchiveFolder = @"\SD\Apps\ChemometricsApp\Archive\";
        }

        /**
         * In the future AppBuilder will generate this code for Customizations.cs
         */
        public override void Init()
        {
            base.Init();
            GeneratedCode.Init(this);           
        }

        public override void SaveOptions()
        {
            base.SaveOptions();
        }

        public override void LoadOptions()
        {
            base.LoadOptions(); 
        }

        public override void ShowNotes()
        {
            Drawing.ClearScreenBuffer(true);

            SmallFont.DrawString(this.Name, 5, 10, false);
            TinyFont.DrawString("ID:" + this.ID, 10, 40, false);
            TinyFont.DrawString("Modified:" + this.BuildDate.ToString("MM/dd/yyyy HH:mm:ss"), 10, 60, false);

            TinyFont.DrawString("Notes:", 10, 95, false);
            TinyFont.DrawString("This model was created by Felix Instruments.  It is used to", 15, 120, false);
            TinyFont.DrawString("predict using chemometric models.", 15, 140, false);

            SmallFont.DrawString("Press any key to continue...", 5, 210, false);
            Display.Update(Display.Buffer); 
        }


        public override void DisplayLot(string aFullLotPath, int aCurrentLotNo, int aTotalLotCount)
        {
            LotUtils.LotStats stats = LotUtils.GetStats(aFullLotPath, 0, false);

            bool invertScreen = false;//scrollb (stats.RecordCount >= 4);

            Drawing.ClearScreenBuffer(!invertScreen);
            //Display.Update();

            string lotPath = LotUtils.GetParentLot(LotUtils.GetRelativeLotPath(aFullLotPath));
            if (lotPath == "")
            {
                lotPath = "\\";
            }
            string lotName = System.IO.Path.GetFileName(aFullLotPath);
            string recordCount = stats.RecordCount.ToString();

            LargeFont.DrawString(lotName, 5, 20, invertScreen);
            SmallFont.DrawString(lotPath, 7, 5, invertScreen);
            TinyFont.DrawString(stats.RecordCount.ToString() + " Measurements in lot", 10, 85, invertScreen);


            lotPath = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Small, lotPath, 380);
            lotName = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Large, lotName, 380);

            //---End of header             
            if (Models.Length <= 2)
            {
                int[] predictionStatXs = new int[] { 15, 200 };
                int[] predictionValueXs = new int[] { 12, 197 };

                for (int i = 0; i < Models.Length; i += 1)
                {
                    LotUtils.LotStats predictionStats = LotUtils.GetStats(aFullLotPath, 1 + i, false);
                    string predictionAvg = StringUtils.Format(predictionStats.Avg, 1);
                    string predictionSD = StringUtils.Format(predictionStats.SD, 1);
                    string predictionName = this.Models[i].PredictionName;//FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Small, this.Models[i].PredictionName + ":", 140); 

                    //predictionSD = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Large, predictionSD, 80);
                    // predictionAvg = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Large, predictionAvg, 80);

                    LargeFont.DrawString(predictionAvg, predictionValueXs[i], 142, invertScreen);

                    SmallFont.DrawString("SD: " + predictionSD, predictionStatXs[i], 205, invertScreen);
                    SmallFont.DrawString("Avg " + predictionName, predictionStatXs[i], 124, invertScreen);
                }
            }
            else if (Models.Length <= 4)
            {
                TinyFont.DrawString("Avg", 235, 112, invertScreen);
                TinyFont.DrawString("SD", 315, 112, invertScreen);

                for (int i = 0; i < Models.Length; i += 1)
                {
                    LotUtils.LotStats predictionStats = LotUtils.GetStats(aFullLotPath, 1 + i, false);
                    string predictionAvg = StringUtils.Format(predictionStats.Avg, 1);
                    string predictionSD = StringUtils.Format(predictionStats.SD, 1);
                    string predictionName = this.Models[i].PredictionName;// FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Small, this.Models[i].PredictionName, 225); 

                    // predictionSD = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Small, predictionSD, 90);
                    //predictionAvg = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Small, predictionAvg, 90);

                    SmallFont.DrawString(predictionName, 12, 128 + (27 * i), invertScreen);

                    SmallFont.DrawString(predictionAvg, 235, 128 + (27 * i), invertScreen);

                    SmallFont.DrawString(predictionSD, 315, 128 + (27 * i), invertScreen);
                }
            }
            else if (Models.Length > 4)
            {
                TinyFont.DrawString("Avg", 104, 115, invertScreen);
                TinyFont.DrawString("SD", 154, 115, invertScreen);

                for (int i = 0; i < (Models.Length > 6 ? 6 : Models.Length); i += 1)
                {
                    LotUtils.LotStats predictionStats = LotUtils.GetStats(aFullLotPath, 1 + i, false);
                    string predictionAvg = StringUtils.Format(predictionStats.Avg, 1);
                    string predictionSD = StringUtils.Format(predictionStats.SD, 1);
                    string predictionName = this.Models[i].PredictionName;//FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, this.Models[i].PredictionName, 85);

                    //predictionSD = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, predictionSD, 50);
                    //predictionAvg = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, predictionAvg, 50);

                    TinyFont.DrawString(predictionName, 12, 132 + (18 * i), invertScreen);

                    TinyFont.DrawString(predictionAvg, 104, 132 + (18 * i), invertScreen);

                    TinyFont.DrawString(predictionSD, 154, 132 + (18 * i), invertScreen);
                }

                if (Models.Length > 6)
                {
                    TinyFont.DrawString("Avg", 297, 115, invertScreen);
                    TinyFont.DrawString("SD", 347, 115, invertScreen);
                }

                for (int i = 6; i < (Models.Length > 13 ? 13 : Models.Length); i += 1)
                {
                    LotUtils.LotStats predictionStats = LotUtils.GetStats(aFullLotPath, 1 + i, false);
                    string predictionAvg = StringUtils.Format(predictionStats.Avg, 1);
                    string predictionSD = StringUtils.Format(predictionStats.SD, 1);
                    string predictionName = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, this.Models[i].PredictionName, 85);

                    //predictionSD = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, predictionSD, 150);
                    //predictionAvg = FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, predictionAvg, 220);

                    TinyFont.DrawString(predictionName, 205, 132 + (18 * (i - 6)), invertScreen);

                    TinyFont.DrawString(predictionAvg, 297, 132 + (18 * (i - 6)), invertScreen);

                    TinyFont.DrawString(predictionSD, 347, 132 + (18 * (i - 6)), invertScreen);
                }
            }
            //--- End of prediction stats

            float widthOfGraph = 391f;

            if (aTotalLotCount > 0)
            {
                string nOfm = aTotalLotCount + " of " + aTotalLotCount;
                int nOfMWidth = FontUtils.MeasureString(FontUtils.FontSize.Tiny, nOfm);

                TinyFont.DrawString(nOfm, (int)(widthOfGraph - (nOfMWidth + 5)), 5, invertScreen);
            }

            Drawing.DrawVerticalScrollbar(aTotalLotCount, aCurrentLotNo, false);

            //TinyFont.DrawString(aCurrentLotNo + " of " + aTotalLotCount, 299, 30, invertScreen);

            Display.Update(Display.Buffer);
        }



        public override void DisplayMeasurement(string aMeasurementFile, int aRecordNumber, int aRecordCount)
        {

            AppMeasurement measurement = new AppMeasurement();
            measurement.FromStream(new MemoryStream(System.IO.File.ReadAllBytes(aMeasurementFile)));

            DisplayMeasurement(measurement, LotUtils.GetRelativeLotPath(System.IO.Path.GetDirectoryName(aMeasurementFile)), aRecordNumber, aRecordCount);
        }

        /*private void DrawBoxes(int paddingBetweenSquares, int squareSize, int squareOffsetX, int squareOffsetY, int solidSquares, int totalSquares, int squareColumns)
        {
            int currentSquareColumn = 0;
            int currentSquareRow = 0;

            for (int i = 0; i < totalSquares; i += 1)
            {

                if (currentSquareColumn == squareColumns)
                { 
                    currentSquareRow += 1;
                    currentSquareColumn = 0;
                } 

                int currentSquareX = squareOffsetX + ((squareSize + paddingBetweenSquares) * currentSquareColumn);
                int currentSquareY = squareOffsetY + ((squareSize + paddingBetweenSquares) * currentSquareRow);

                if (i < solidSquares)
                {
                    //G.FillRectangle(new SolidBrush(Color.White), currentSquareX, currentSquareY, squareSize, squareSize);
                    Drawing.DrawRectangle(currentSquareX, currentSquareY, squareSize, squareSize, true, Drawing.PixelColor.White);
                }
                else
                {
                    //G.DrawRectangle(new Pen(Color.White, 1), currentSquareX, currentSquareY, squareSize - 1, squareSize - 1);
                    Drawing.DrawRectangle(currentSquareX, currentSquareY, squareSize, squareSize, false, Drawing.PixelColor.White);
                } 

                currentSquareColumn += 1;
            }
        }
        
        private void DrawPlusOrMinus(int aX, int aY, int aWidth, int thickness, bool black)
        { 
            if (!black) 
            {
                Drawing.DrawRectangle((int)(aX + (aWidth / 2f) - (thickness / 2f)), aY, thickness, aWidth, true, Drawing.PixelColor.Black);
                Drawing.DrawRectangle(aX, (int)(aY + (aWidth / 2f) - (thickness / 2f)), aWidth, thickness, true, Drawing.PixelColor.Black);
                Drawing.DrawRectangle(aX, aY + aWidth + 2, aWidth, thickness, true, Drawing.PixelColor.Black);
            }
            else
            {
                Drawing.DrawRectangle((int)(aX + (aWidth / 2f) - (thickness / 2f)), aY, thickness, aWidth, true, Drawing.PixelColor.White);
                Drawing.DrawRectangle(aX, (int)(aY + (aWidth / 2f) - (thickness / 2f)), aWidth, thickness, true, Drawing.PixelColor.White);
                Drawing.DrawRectangle(aX, aY + aWidth + 2, aWidth, thickness, true, Drawing.PixelColor.White);
            } 
        }
         
        public void DisplayMeasurement(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            string fruitPath = LotUtils.GetParentLot(LotUtils.GetFullLotPath(aRelativeLot));
            string binPath = LotUtils.GetParentLot(fruitPath);
            string sideAPath = fruitPath + "SIDE001\\";
            string sideBPath = fruitPath + "SIDE002\\";
             
            LotUtils.LotStats binStats = LotUtils.GetStats(binPath, 1, false); 
            LotUtils.LotStats sideAStats = LotUtils.GetStats(sideAPath, 1, false);
            LotUtils.LotStats sideBStats = LotUtils.GetStats(sideBPath, 1, false);
 
            int sideA_Count = sideAStats.RecordCount;
            float sideA_DM = sideAStats.Avg;
            float sideA_Variance = sideAStats.SD;

            int sideB_Count = sideBStats.RecordCount;
            float sideB_DM = sideBStats.Avg;
            float sideB_Variance = sideBStats.SD;

            int avocado_Count = System.IO.Directory.GetDirectories(binPath).Length;
            float avocado_DM = binStats.Avg;  
            float avocado_Variance = binStats.SD;
            
            float total_DM = binStats.Avg;
            float total_Variance = binStats.SD;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);

          //  TinyFont.DrawString(fruitPath, 20, 10, true);
          //  TinyFont.DrawString(sideAPath, 20, 25, true);
           // TinyFont.DrawString(sideBPath, 20, 35, true);

            SmallFont.DrawString(
                                Core.Utils.StringUtils.Format(fruitStats.RecordCount, 1) + " - " +
                                Core.Utils.StringUtils.Format(fruitStats.SD, 1), 140, 5, true);
            SmallFont.DrawString(
                                Core.Utils.StringUtils.Format(sideAStats.RecordCount, 1) + " - " +
                                Core.Utils.StringUtils.Format(sideAStats.SD, 1), 140, 20, true);
            SmallFont.DrawString(
                                Core.Utils.StringUtils.Format(sideBStats.RecordCount, 1) + " - " +
                                Core.Utils.StringUtils.Format(sideBStats.SD, 1), 140, 35, true);
 


            DisplayMeasurementScenario0(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario1(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario2(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario3(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario4(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario5(measurement, aRelativeLot, aRecordNumber, aRecordCount);
            Environment.KeyPad.WaitForKeypress();
            DisplayMeasurementScenario6(measurement, aRelativeLot, aRecordNumber, aRecordCount);
        }

        public void DisplayMeasurementScenario0(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 0;
            float sideA_DM = 0f;
            float sideA_Variance = 0f;

            int sideB_Count = 0;
            float sideB_DM = 0f;
            float sideB_Variance = 0f;

            int avocado_Count = 0;
            float avocado_DM = 0f;  
            float avocado_Variance = 0f;
            
            float total_DM = 0f;
            float total_Variance = 0;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }
        public void DisplayMeasurementScenario1(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 1;
            float sideA_DM = 23.1f;
            float sideA_Variance = 1.2f;

            int sideB_Count = 0;
            float sideB_DM = 0f;
            float sideB_Variance = 0f;

            int avocado_Count = 0;
            float avocado_DM = 0f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 0;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }

        public void DisplayMeasurementScenario2(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 3;
            float sideA_DM = 23.1f;
            float sideA_Variance = 0.9f;

            int sideB_Count = 0;
            float sideB_DM = 0f;
            float sideB_Variance = 0f;

            int avocado_Count = 0;
            float avocado_DM = 0f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 0;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }

        public void DisplayMeasurementScenario3(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 3;
            float sideA_DM = 23.1f;
            float sideA_Variance = 0.9f;

            int sideB_Count = 2;
            float sideB_DM = 21.1f;
            float sideB_Variance = 0.5f;

            int avocado_Count = 0;
            float avocado_DM = 0f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 0;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }

        public void DisplayMeasurementScenario4(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 3;
            float sideA_DM = 23.1f;
            float sideA_Variance = 0.9f;

            int sideB_Count = 3;
            float sideB_DM = 21.1f;
            float sideB_Variance = 0.5f;

            int avocado_Count = 1;
            float avocado_DM = 22.1f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 0;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }
        public void DisplayMeasurementScenario5(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 3;
            float sideA_DM = 23.1f;
            float sideA_Variance = 0.9f;

            int sideB_Count = 3;
            float sideB_DM = 21.1f;
            float sideB_Variance = 0.5f;

            int avocado_Count = 3;
            float avocado_DM = 19.5f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 1.2f;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }

        public void DisplayMeasurementScenario6(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            int sideA_Count = 3;
            float sideA_DM = 23.1f;
            float sideA_Variance = 0.9f;

            int sideB_Count = 3;
            float sideB_DM = 21.1f;
            float sideB_Variance = 0.5f;

            int avocado_Count = 10;
            float avocado_DM = 19.5f;  
            float avocado_Variance = 1.2f;
            
            float total_DM = 23.1f;
            float total_Variance = 1.2f;
 
            DrawAppSplashScreen(measurement, aRelativeLot, aRecordNumber, aRecordCount,
            sideA_Count, sideA_DM, sideA_Variance,
            sideB_Count, sideB_DM, sideB_Variance, 
            avocado_Count, avocado_DM, avocado_Variance, 
            total_DM, total_Variance);
        }

        public void DrawAppSplashScreen(AppMeasurement measurement, 
            string aRelativeLot, int aRecordNumber, int aRecordCount,
            int sideA_Count, float sideA_DM, float sideA_Variance, 
            int sideB_Count, float sideB_DM, float sideB_Variance, 
            int avocado_Count, float avocado_DM, float avocado_Variance, 
            float total_DM, float total_Variance)
        {
            bool invertScreen = true;

            bool hideUnusedBoxes = true;

            Drawing.ClearScreenBuffer(!invertScreen);

            //Draws the black region on the left
            Drawing.DrawRectangle(0, 0, 135, 240, true, Drawing.PixelColor.Black); 
    
            int minimumSideMeasurements = 3;
            float minimumSideVariance = 1f;
            int boxesPerRow = 5;
            int avocadosPerBin = 10;
            int boxSize = 17;
            int boxPadding = 5;

            //Side A
            SmallFont.DrawString("Side A", 12, 10, false);

            if ((sideA_Count >= minimumSideMeasurements) && (sideA_Variance <= minimumSideVariance))
            {
                if (hideUnusedBoxes)
                {
                    DrawBoxes(boxPadding, boxSize, 13, 35, sideA_Count, sideA_Count, sideA_Count); 
                }
                else 
                {
                    DrawBoxes(boxPadding, boxSize, 13, 35, boxesPerRow, boxesPerRow, boxesPerRow); 
                }
            }
            else 
            {
                DrawBoxes(boxPadding, boxSize, 13, 35, sideA_Count, boxesPerRow, boxesPerRow); 
            }

            if (sideA_Count > 0)
            {
                TinyFont.DrawString(Core.Utils.StringUtils.Format(sideA_DM, 1) + "%", 13, 55, false); 
                if (sideA_Variance > 0)
                {
                    DrawPlusOrMinus(63, 57, 7, 1, true);
                    TinyFont.DrawString(Core.Utils.StringUtils.Format(sideA_Variance, 1), 72, 55, false); 
                }
            }
            else 
            {
                TinyFont.DrawString("Not Measured", 13, 55, false);  
            }

            //Side B 
            SmallFont.DrawString("Side B", 12, 80, false);
 
            if ((sideB_Count >= minimumSideMeasurements) && (sideB_Variance <= minimumSideVariance))
            {
                if (hideUnusedBoxes)
                {
                    DrawBoxes(boxPadding, boxSize, 13, 105, sideB_Count, sideB_Count, sideB_Count); 
                }
                else 
                {
                    DrawBoxes(boxPadding, boxSize, 13, 105, boxesPerRow, boxesPerRow, boxesPerRow); 
                }
            }
            else 
            {
                DrawBoxes(boxPadding, boxSize, 13, 105, sideB_Count, boxesPerRow, boxesPerRow); 
            }

            
            if (sideB_Count > 0)
            {
                TinyFont.DrawString(Core.Utils.StringUtils.Format(sideB_DM, 1) + "%", 13, 125, false); 
                if (sideB_Variance > 0)
                {
                    DrawPlusOrMinus(63, 127, 7, 1, true);
                    TinyFont.DrawString(Core.Utils.StringUtils.Format(sideB_Variance, 1), 72, 125, false); 
                }
            }
            else 
            {
                TinyFont.DrawString("Not Measured", 13, 125, false);  
            }

            //Avocado
            SmallFont.DrawString("Avocado", 12, 150, false);  
            DrawBoxes(boxPadding, boxSize, 13, 175, avocado_Count, avocadosPerBin, boxesPerRow); 
            if (avocado_Count > 0)
            {
                TinyFont.DrawString(Core.Utils.StringUtils.Format(avocado_DM, 1) + "%", 13, 217, false); 
                if (avocado_Variance > 0)
                {
                    DrawPlusOrMinus(63, 219, 7, 1, true);
                    TinyFont.DrawString(Core.Utils.StringUtils.Format(avocado_Variance, 1), 72, 217, false); 
                }
            } 

            SmallFont.DrawString("\\BIN001", 162, 50, true);   
            if (sideA_Count > 0)
            {
                LargeFont.DrawString(Core.Utils.StringUtils.Format(total_DM, 1) + "%", 160, 70, true);   
                if (total_Variance > 0)
                {
                    DrawPlusOrMinus(162, 170, 12, 2, false);
                    SmallFont.DrawString(Core.Utils.StringUtils.Format(total_Variance, 1) , 175, 165, true); 
                }
                SmallFont.DrawString("Dry Matter", 162, 135, true); 
            }
            else 
            {
                TinyFont.DrawString("Record measurements to fill", 162, 80, true); 
                TinyFont.DrawString("all the boxes for each side", 162, 95, true); 
                TinyFont.DrawString("and avocado in this bin", 162, 110, true); 

                TinyFont.DrawString("Press Up\\Down to change bins", 162, 135, true);  
                
                TinyFont.DrawString("Press Right for the main menu", 162, 165, true);  
            }


            UpdateBatteryLevel(true);

            Display.Update(Display.Buffer);
        }


        public void UpdateBatteryLevel(bool aUpdateBattery)
        { 
            double batLevel;
 
            if (aUpdateBattery)
            {
                batLevel = Core.Hardware.Battery.GetUpdatedLevel();
            }
            else
            {
                batLevel = Core.Hardware.Battery.CurrentLevel;
            }

            Drawing.DrawRectangle(328 + 7, 13 - 7, 22, 12, false, Drawing.PixelColor.Black);
            Drawing.DrawRectangle(330 + 7, 15 - 7, 18, 8, true, Drawing.PixelColor.White);

            int max = 18;
            int min = 1;
            int value = 1 + System.Math.Max(System.Math.Min((int)(min + (((max - min) / 100f) * batLevel)), 100), 1);

            Drawing.DrawRectangle(330 + 7, 15 - 7, value, 8, true, Drawing.PixelColor.Black);

            Drawing.DrawRectangle(350 + 7, 15 - 7, 2, 8, false, Drawing.PixelColor.Black);

            if (batLevel >= 100)
            {
                batLevel = 99;
            }

            TinyFont.DrawString(ref Display.Buffer, (int)batLevel + "%", 362 + 3, 12 - 7, true);

        }*/
        
        public void DisplayMeasurement(AppMeasurement measurement, string aRelativeLot, int aRecordNumber, int aRecordCount)
        {
            bool invertScreen = true;

            Drawing.ClearScreenBuffer(!invertScreen);
            
            SmallFont.DrawString(ref Display.Buffer, LotUtils.GetRelativeLotPath(aRelativeLot), 7, 5, true);

            float widthOfGraph = 391f;

            if ((aRecordNumber == 0) && (aRecordCount == 0))
            {
                TinyFont.DrawString("Saving...", (int)(widthOfGraph - 55), 5, invertScreen);
            }
            else
            {
                string nOfm = aRecordNumber + " of " + aRecordCount;
                int nOfMWidth = FontUtils.MeasureString(FontUtils.FontSize.Tiny, nOfm);

                TinyFont.DrawString(nOfm, (int)(widthOfGraph - (nOfMWidth + 5)), 5, invertScreen);
            }


            TinyFont.DrawString("Measured: " + measurement.Timestamp.ToString("MM/dd/yyyy HH:mm:ss"), 7, 37, invertScreen);

            string gpsString = "";

            if ((measurement.Longitude != 0) || (measurement.Latitude != 0))
            {
                gpsString = StringUtils.Format(measurement.Longitude, 5) + ", " +
                            StringUtils.Format(measurement.Latitude, 5) + " " +
                            ((measurement.GPSFixQuality > 0) ? "(GPS Fix)" : "(No GPS Fix)");
            }
            else
            {
                gpsString = "Unknown (No GPS Fix)";
            }

            TinyFont.DrawString("Location: " + gpsString, 7, 57, invertScreen);
            TinyFont.DrawString("Tags: " + FontUtils.AddEllipseToEndOfString(FontUtils.FontSize.Tiny, measurement.Tags, 320), 7, 77, invertScreen);
             
            if ((aRecordCount >= 3) && (aRecordCount < 10))
            {
		LotUtils.LotStats predictionStats = LotUtils.GetStats(LotUtils.GetFullLotPath(aRelativeLot), 1, false);
		
		if (predictionStats.SD > 1f)
		{
			float sumOfSqDev = (float)System.Math.Pow(2, predictionStats.SD) * ((float)aRecordCount - 1f);

			float bestCaseSD = 0f;
			int bestCase = 0; 
			for (int i = aRecordCount + 1; i <= 10; i +=1) 
			{
			   bestCaseSD = (float)System.Math.Sqrt(sumOfSqDev/((float)i-1f));
			   bestCase = i;
			   if (bestCaseSD < 1f)
			   {
				break;
			   }
			}

			if (bestCaseSD < 1f)
			{
				TinyFont.DrawString("Passing StDev of " + StringUtils.Format(bestCaseSD, 2) + " in " + bestCase + " scans", 7, 97, invertScreen);
			}
			else
			{
				TinyFont.DrawString("Failing StDev of " + StringUtils.Format(bestCaseSD, 2) + " in 10 scans", 7, 97, invertScreen);		
			}
 	    	}
            }

	    
	    

            if (Models.Length <= 2)
            {
                int[] predictionStatXs = new int[] { 15, 200 };
                int[] predictionValueXs = new int[] { 12, 197 };

                for (int i = 0; i < Models.Length; i += 1)
                {
                    SmallFont.DrawString(measurement.PredictionNames[i], predictionStatXs[i], 124, invertScreen);
                    LargeFont.DrawString(StringUtils.Format(measurement.PredictionValues[i], Models[i].DisplayFormatDecimalPrecision), predictionValueXs[i], 142, invertScreen);
                }
            }
            else if (Models.Length <= 4)
            {
                for (int i = 0; i < Models.Length; i += 1)
                {
                    string predictionName = measurement.PredictionNames[i];

                    SmallFont.DrawString(predictionName, 12, 128 + (27 * i), invertScreen);
                    SmallFont.DrawString(StringUtils.Format(measurement.PredictionValues[i], Models[i].DisplayFormatDecimalPrecision), 235, 128 + (27 * i), invertScreen);
                }
            }
            else if (Models.Length > 4)
            {
                for (int i = 0; i < (Models.Length > 6 ? 6 : Models.Length); i += 1)
                {
                    string predictionName = measurement.PredictionNames[i];

                    TinyFont.DrawString(predictionName, 12, 132 + (18 * i), invertScreen);
                    TinyFont.DrawString(StringUtils.Format(measurement.PredictionValues[i], Models[i].DisplayFormatDecimalPrecision), 104, 132 + (18 * i), invertScreen);
                }


                for (int i = 6; i < (Models.Length > 13 ? 13 : Models.Length); i += 1)
                {
                    string predictionName = measurement.PredictionNames[i];

                    TinyFont.DrawString(predictionName, 205, 132 + (18 * (i - 6)), invertScreen);
                    TinyFont.DrawString(StringUtils.Format(measurement.PredictionValues[i], Models[i].DisplayFormatDecimalPrecision), 297, 132 + (18 * (i - 6)), invertScreen);
                }
            }

            if (aRecordCount > 1)
            {
                Drawing.DrawVerticalScrollbar(aRecordCount, aRecordNumber, false);
            }

            Display.Update(Display.Buffer);
        }

        public override bool CollectRawSpectra(Measurement aMeasurement)
        {
            bool result = base.CollectRawSpectra(aMeasurement);
            SetPredictions((AppMeasurement)aMeasurement);
            return result;
        }

        protected bool DisplayMeasurementWhileSaving = true;

        public override void SaveMeasurement(Measurement aMeasurement)
        {
            AppMeasurement newMeasurement = (AppMeasurement)aMeasurement;

            if (DisplayMeasurementWhileSaving)
            {
                DisplayMeasurement(newMeasurement, aMeasurement.Lot, 0, 0);
            }

            base.SaveMeasurement(newMeasurement);

            //DirectoryInfo di = new DirectoryInfo(aMeasurement.Filename);
            
            Settings.WriteToSDCard(this.Name + ".DefaultLot", Options.DefaultLot);
        }

        public override void SetPredictions(AppMeasurement aMeasurement)
        {
            AppMeasurement newMeasurement = (AppMeasurement)aMeasurement;
            newMeasurement.PredictionNames = new string[Models.Length];
            newMeasurement.PredictionValues = new float[Models.Length];

            for (int i = 0; i < Models.Length; i += 1)
            {
                Model currentModel = ((Model)Models[i]);
                currentModel.SetPrediction(newMeasurement);

                newMeasurement.PredictionNames[i] = currentModel.PredictionName;
                newMeasurement.PredictionValues[i] = currentModel.PredictionValue;
            }
        }

        public override void WriteTextFileHeader(Measurement aMeasurement, System.IO.TextWriter tr)
        {
            tr.Write("Measurement ID\tDevice ID\tLot");

            for (int i = 0; i < Models.Length; i += 1)
            {
                tr.Write("\t" + Models[i].PredictionName);
            }

            tr.Write("\r\n");
        }

        public override void WriteTextFileEntry(Measurement aMeasurement, System.IO.TextWriter tr)
        {
            AppMeasurement newMeasurement = (AppMeasurement)aMeasurement;

            tr.Write(newMeasurement.MeasurementID + "\t" +
                        newMeasurement.DeviceID + "\t" +
                        newMeasurement.Lot);

            for (int i = 0; i < Models.Length; i += 1)
            {
                tr.Write("\t" + StringUtils.Format(newMeasurement.PredictionValues[i], Models[i].TextOutputDecimalPrecision));
            }

            tr.Write("\r\n");
        }
    }
}

