using System;
using Microsoft.SPOT;
using F75XDeviceApp.Common; 
using System.IO;
using System.Text;
using System.Threading;
using Core.Utils;
using Common;

namespace F75XDeviceApp
{
    public class AppMeasurement : Measurement
    {

        public int SpecimenScansToAverage = 1;
        public int ReferenceScansToAverage = 1;

        public float[] LightReferenceSpectra = new float[0];
        public float[] DarkReferenceSpectra = new float[0];
        public float ReferenceIntegrationTime = 0;

        public float[] LightSpecimenSpectra = new float[0];
        public float[] DarkSpecimenSpectra = new float[0];
        public float SampleIntegrationTime = 0;

        public float WavelengthInterpolationC0 = 0f;
        public float WavelengthInterpolationC1 = 0f;
        public float WavelengthInterpolationC2 = 0f;
        public float WavelengthInterpolationC3 = 0f;
        public float WavelengthInterpolationC4 = 0f;
        public float WavelengthInterpolationC5 = 0f;

        public int SpectrometerSensorCount = 256; 

        public float SpectrometerZero = 0f;

        public string[] PredictionNames = new string[0];
        public float[] PredictionValues = new float[0];

        public string[] UserDefinedValues = new string[0];

        public float Longitude = 0f;
        public float Latitude = 0f;
        public byte GPSFixQuality = 0;
        public byte GPSSatellites = 0;

        static byte[] buffer = new byte[8096];

        public override void ToStream(Stream aStream)
        {
            BinaryFormatVersion = 0x10;

            //Writes the basic header of a measurement file.
            base.ToStream(aStream);

            byte[] tempBytes;

            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC0);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC1);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC2);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC3);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC4);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            tempBytes = BitUtils.GetFloatBytes(WavelengthInterpolationC5);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetBytes((int)LightReferenceSpectra.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            foreach (float value in LightReferenceSpectra)
            {
                tempBytes = BitUtils.GetFloatBytes(value);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = BitUtils.GetBytes((int)DarkReferenceSpectra.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (float value in DarkReferenceSpectra)
            {
                tempBytes = BitUtils.GetFloatBytes(value);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = BitUtils.GetBytes((int)LightSpecimenSpectra.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (float value in LightSpecimenSpectra)
            {
                tempBytes = BitUtils.GetFloatBytes(value);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = BitUtils.GetBytes((int)DarkSpecimenSpectra.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (float value in DarkSpecimenSpectra)
            {
                tempBytes = BitUtils.GetFloatBytes(value);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }
             
            tempBytes = BitUtils.GetFloatBytes(ReferenceIntegrationTime);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetFloatBytes(SampleIntegrationTime);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetBytes((int)ReferenceScansToAverage);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetBytes((int)SpecimenScansToAverage);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetFloatBytes(SpectrometerZero);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetBytes((int)PredictionNames.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (string value in PredictionNames)
            {
                tempBytes = Encoding.UTF8.GetBytes(value);
                aStream.WriteByte((byte)tempBytes.Length);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = BitUtils.GetBytes((int)PredictionValues.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (float value in PredictionValues)
            {
                tempBytes = BitUtils.GetFloatBytes(value);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = Encoding.UTF8.GetBytes(Tags);
            aStream.WriteByte((byte)tempBytes.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = Encoding.UTF8.GetBytes(Lot);
            aStream.WriteByte((byte)tempBytes.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetBytes((int)UserDefinedValues.Length);
            aStream.Write(tempBytes, 0, tempBytes.Length);
            foreach (string value in UserDefinedValues)
            {
                tempBytes = Encoding.UTF8.GetBytes(value);
                aStream.WriteByte((byte)tempBytes.Length);
                aStream.Write(tempBytes, 0, tempBytes.Length);
            }

            tempBytes = BitUtils.GetFloatBytes(Longitude);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            tempBytes = BitUtils.GetFloatBytes(Latitude);
            aStream.Write(tempBytes, 0, tempBytes.Length);

            aStream.WriteByte(GPSFixQuality);
            aStream.WriteByte(GPSSatellites);

            aStream.Flush();

        }

        public override void FromBytes(byte[] aData)
        {
            FromStream(new MemoryStream(aData));
        }

        public override void FromStream(Stream aStream)
        {
            base.FromStream(aStream);

            buffer = new byte[(int)(aStream.Length - aStream.Position)];
            aStream.Read(buffer, 0, buffer.Length);

            int dataOffset = 0;

            WavelengthInterpolationC0 = BitUtils.ToFloat(buffer, ref dataOffset);
            WavelengthInterpolationC1 = BitUtils.ToFloat(buffer, ref dataOffset);
            WavelengthInterpolationC2 = BitUtils.ToFloat(buffer, ref dataOffset);
            WavelengthInterpolationC3 = BitUtils.ToFloat(buffer, ref dataOffset);
            WavelengthInterpolationC4 = BitUtils.ToFloat(buffer, ref dataOffset);
            WavelengthInterpolationC5 = BitUtils.ToFloat(buffer, ref dataOffset);

            LightReferenceSpectra = new float[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < LightReferenceSpectra.Length; i += 1)
            {
                LightReferenceSpectra[i] = BitUtils.ToFloat(buffer, ref dataOffset);
            }

            DarkReferenceSpectra = new float[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < DarkReferenceSpectra.Length; i += 1)
            {
                DarkReferenceSpectra[i] = BitUtils.ToFloat(buffer, ref dataOffset);
            }

            LightSpecimenSpectra = new float[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < LightSpecimenSpectra.Length; i += 1)
            {
                LightSpecimenSpectra[i] = BitUtils.ToFloat(buffer, ref dataOffset);
            }

            DarkSpecimenSpectra = new float[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < DarkSpecimenSpectra.Length; i += 1)
            {
                DarkSpecimenSpectra[i] = BitUtils.ToFloat(buffer, ref dataOffset);
            }
             
            ReferenceIntegrationTime = BitUtils.ToFloat(buffer, ref dataOffset);
            SampleIntegrationTime = BitUtils.ToFloat(buffer, ref dataOffset);

            ReferenceScansToAverage = BitUtils.ToInt32(buffer, ref dataOffset);
            SpecimenScansToAverage = BitUtils.ToInt32(buffer, ref dataOffset);

            SpectrometerZero = BitUtils.ToFloat(buffer, ref dataOffset);

            PredictionNames = new string[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < PredictionNames.Length; i += 1)
            {
                PredictionNames[i] = BitUtils.ToString(buffer, ref dataOffset, true);
            }

            PredictionValues = new float[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < PredictionValues.Length; i += 1)
            {
                PredictionValues[i] = BitUtils.ToFloat(buffer, ref dataOffset);
            }

            Tags = BitUtils.ToString(buffer, ref dataOffset, true);
            Lot = BitUtils.ToString(buffer, ref dataOffset, true);

            UserDefinedValues = new string[BitUtils.ToInt32(buffer, ref dataOffset)];
            for (int i = 0; i < UserDefinedValues.Length; i += 1)
            {
                UserDefinedValues[i] = BitUtils.ToString(buffer, ref dataOffset, true);
            }

            Longitude = BitUtils.ToFloat(buffer, ref dataOffset);
            Latitude = BitUtils.ToFloat(buffer, ref dataOffset);
            GPSFixQuality = buffer[dataOffset];
            dataOffset += 1;
            GPSSatellites = buffer[dataOffset];
            dataOffset += 1;

        }

    }
}
